namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\InventoryItem;

class UpdateDutchPrices extends Command
{
    protected $signature = 'dutch-prices:update';

    protected $description = 'Update Dutch auction prices for inventory items';

    public function handle()
    {
        $items = InventoryItem::where('dutch_auction_enabled', true)->get();

        foreach ($items as $item) {
            $newPrice = $item->calculateDutchPrice();
            $item->update(['current_price' => $newPrice]);
        }

        $this->info('Dutch auction prices updated successfully.');
    }
}